/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.compat.jei.laser;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.deepresonance.compat.jei.laser.LaserRecipeWrapper;
import mcjty.deepresonance.modules.machines.MachinesModule;
import mcjty.deepresonance.modules.machines.util.config.LaserConfig;
import mcjty.lib.varia.ComponentFactory;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class LaserRecipeCategory
implements IRecipeCategory<LaserRecipeWrapper> {
    private final IGuiHelper guiHelper;
    private final IDrawable background;
    private final IDrawable slot;
    private final IDrawable icon;
    public static final ResourceLocation ID = new ResourceLocation("deepresonance", "laser");

    public LaserRecipeCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.slot = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)MachinesModule.LASER_BLOCK.get()));
        this.background = guiHelper.createBlankDrawable(150, 62);
    }

    public void setIngredients(LaserRecipeWrapper recipe, IIngredients ingredients) {
        ingredients.setInput((IIngredientType)VanillaTypes.ITEM_STACK, (Object)recipe.getItem());
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Class<? extends LaserRecipeWrapper> getRecipeClass() {
        return LaserRecipeWrapper.class;
    }

    public Component getTitle() {
        return ComponentFactory.literal((String)"Deep Resonance Laser");
    }

    public ResourceLocation getUid() {
        return ID;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void draw(LaserRecipeWrapper recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        this.slot.draw(stack);
        Font font = Minecraft.m_91087_().f_91062_;
        font.m_92883_(stack, "Per " + LaserConfig.RCL_PER_CATALYST.get() + "mb RCL", 24.0f, 0.0f, -1);
        font.m_92883_(stack, "and " + LaserConfig.CRYSTAL_LIQUID_PER_CATALYST.get() + "mb crystal", 24.0f, 10.0f, -1);
        recipe.drawInfo(stack);
    }

    public void setRecipe(IRecipeLayout recipeLayout, LaserRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup group = recipeLayout.getItemStacks();
        group.init(0, true, 0, 0);
        group.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
    }
}

